# btc16mf_unique_fixed.py
MAX_VECTORS = 16_777_216
SEED_VECTORS = 4
CTv_PUBKEY = "<YOUR_PUBLIC_KEY>"
SAFE_ZERO = "0x0"

# Seed r_dim / Ω for seeds (scaled, unique)
SEED_PARAMS = [
    ("0x09502f90", "0x812"),  # seed 1
    ("0x12a05f20", "0x502"),  # seed 2
    ("0x1bf08eb0", "0x310"),  # seed 3
    ("0x2540be40", "0x192")   # seed 4
]

FIBS = [1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610]

FOLD_DOUBLINGS = [
    4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048,
    4096, 8192, 16384, 32768, 65536, 131072,
    262144, 524288, 1048576, 2097152, 4194304,
    8388608
]

def generate_hdgl_covenant(pubkey=CTv_PUBKEY):
    script = [f"{pubkey} OP_CHECKSIGVERIFY"]

    # Emit seed vectors
    for idx, (r_dim, omega) in enumerate(SEED_PARAMS):
        script.append(f"{SAFE_ZERO} OP_HDGL_VEC_ADD OP_EQUALVERIFY")
        script.append(f"{idx*4} OP_ADD {idx*4} OP_EQUALVERIFY")
        omega_int = int(omega, 16)
        script.append(f"{omega_int} {omega_int} {omega_int} OP_WITHINVERIFY")
        script.append(f"{r_dim} {omega} OP_HDGL_PARAM_ADD OP_EQUALVERIFY")
        script.append("")

    # Folding with Fibonacci delta for uniqueness
    vector_count = SEED_VECTORS
    fib_index = 0
    for fold in FOLD_DOUBLINGS:
        vector_count *= 2
        script.append(f"OP_VEC_DUP {vector_count//2} OP_HDGL_VEC_ADD OP_EQUALVERIFY")
        
        # Param delta using Fibonacci sequence
        fib_delta = FIBS[fib_index % len(FIBS)]
        fib_index += 1

        param = SEED_PARAMS[(vector_count.bit_length()-1) % len(SEED_PARAMS)]
        script.append(f"{vector_count//2} {vector_count//2} OP_HDGL_PARAM_ADD OP_EQUALVERIFY")
        
        # Correct conversion from hex to int
        omega_int = int(param[1], 16)
        omega_min = omega_int + fib_delta
        omega_max = omega_int + fib_delta
        script.append(f"{omega_int} {omega_min} {omega_max} OP_WITHINVERIFY")
        script.append("")

    script.append("OP_CHECKTEMPLATEVERIFY")
    return "\n".join(script)

if __name__ == "__main__":
    covenant_script = generate_hdgl_covenant()
    print("=== Fully Folded 16,777,216-Vector HDGL Covenant (Fully Unique, Fixed) ===")
    print(covenant_script)
